VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ArmExcelLead"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'what is new
'2.8.1 : intems into export support (JN)

Private mo_Db As Object
Private mt_Cst As Type_CstValues
Private mo_ExcelApp As Object     'Excel.Application
Private mo_TemplateSheet As Object
Private mo_TemplateWorkbook As Object
Private mo_Sheet As Object
Private mo_Workbook As Object
'main sales project cursor
Private ml_SPCursor As Long
'name of server when  creating internal connection
Private ms_Server As String
'name of database to connect
Private ms_Db As String
'user name when opening connection to sql server
Private ms_User As String
'user passwrod
Private ms_Pwd As String
'application name displayed in connection row in sql server manager
Private ms_App As String
'if component has created its own connection or got connected armdb instance
Private mb_InternalConnection As Boolean
'request used to insert keys into temporary key table
Private ms_InsertTempKeyRequest As String
'request to create temporary table
Private ms_CreateTempTableRequest As String
'request to drop temporary table
Private ms_DropTempTableRequest As String
'number of key which are inserted into temporary key table in one go
Private ml_InsertTempKeyCount As Long
'array of keys
Private mv_MultiKey As Variant
'user id
Private ms_User_ID As String
'Language code
Private ms_Language_Code As String
'locale ID
Private ml_LocalID As Long
Private ml_CodePage As Long
'excel row counter
Private ml_RowCounter As Long
Private ms_CommentLabel As String
Private ms_SPRequest As String
Private ms_SalesRepRequest As String
Private ms_CompanyRequest As String
Private ms_ActionRequest As String
Private ms_ItemsRequest As String
Private ms_LabelRequest As String
'name of field which contains label name in label cursor
Private ms_LabelField As String
'name of field which contains translated text
Private ms_TextField As String

Private mo_Trace As Object

Public Function Load_A_Com()

End Function

Public Function Unload_A_Com()

  If mb_InternalConnection Then
    Call mo_Db.Disconnect
  End If
  Set mo_TemplateSheet = Nothing
  Set mo_Sheet = Nothing
  Set mo_Workbook = Nothing
  Set mo_TemplateWorkbook = Nothing
  Set mo_ExcelApp = Nothing
  Set mo_Db = Nothing
  Set mo_Trace = Nothing
End Function

Public Property Set ArmDb(ByRef lo_Db As Object)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ArmDb_Set")
#End If
  
  Set mo_Db = lo_Db

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ArmDb_Set")
#End If
End Property

Public Property Set Type_CstValues(ByRef lt_Type_CstValues As Type_CstValues)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ArmDb_Set")
#End If
  
  Set mt_Cst = lt_Type_CstValues

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ArmDb_Set")
#End If
End Property

'set values for connection to sql server. If there is not connected armdb instance, create its own internal connection
Property Let ConnectString(as_Value As String)
Dim la_Params() As String

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ConnectString_Let")
#End If
  
  If (as_Value <> "") Then
    la_Params = Split(as_Value, mt_Cst.SepKeyCar, 5)
    ms_Server = la_Params(0)
    ms_Db = la_Params(1)
    ms_User = la_Params(2)
    ms_Pwd = la_Params(3)
    If UBound(la_Params) >= 4 Then
      ms_App = la_Params(4)
    Else
      ms_App = "ArmExcelLead"
    End If
  Else
    ms_Server = ""
    ms_Db = ""
    ms_User = ""
    ms_Pwd = ""
  End If
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ConnectString_Let")
#End If
  Exit Property
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:ConnectString_Let", "as_Value=" & as_Value)
#End If
End Property

Property Let CreateTempTableRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CreateTempTableRequest_Let")
#End If
  
  ms_CreateTempTableRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CreateTempTableRequest_Let")
#End If
End Property

Property Get CreateTempTableRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CreateTempTableRequest_Get")
#End If
  
  CreateTempTableRequest = ms_CreateTempTableRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CreateTempTableRequest_Get")
#End If
End Property

Property Let LocalID(al_Value As Long)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:LocalID_Let")
#End If
  
  ml_LocalID = al_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:LocalID_Let")
#End If
End Property

Property Get LocalID() As Long
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:LocalID_Get")
#End If
  
  LocalID = ml_LocalID

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:LocalID_Get")
#End If
End Property

Property Let Codepage(al_Value As Long)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CodePage_Let")
#End If
  
  ml_CodePage = Codepage

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CodePage_Let")
#End If
End Property

Property Get Codepage() As Long
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CodePage_Get")
#End If
  
  Codepage = ml_CodePage

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CodePage_Get")
#End If
End Property

Property Let DropTempTableRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:DropTempTableRequest_Let")
#End If
  
  ms_DropTempTableRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:DropTempTableRequest_Let")
#End If
End Property

Property Get DropTempTableRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:DropTempTableRequest_Get")
#End If
  
  DropTempTableRequest = ms_DropTempTableRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:DropTempTableRequest_Get")
#End If
End Property

'sql request which insert many temporary keys into temp table in one go
Property Let InsertTempKeyRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:InsertTempKeyRequest_Let")
#End If
  
  ms_InsertTempKeyRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:InsertTempKeyRequest_Let")
#End If
End Property

Property Get InsertTempKeyRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:InsertTempKeyRequest_Get")
#End If
  
  InsertTempKeyRequest = ms_InsertTempKeyRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:InsertTempKeyRequest_Get")
#End If
End Property

'number of keys inserted into temporary table in one go
Property Let InsertTempKeyCount(al_Value As Long)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:InsertTempKeyCount_Let")
#End If
  
  ml_InsertTempKeyCount = al_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:InsertTempKeyCount_Let")
#End If
End Property

Property Get InsertTempKeyCount() As Long
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:InsertTempKeyCount_Get")
#End If
  
  InsertTempKeyCount = ml_InsertTempKeyCount

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:InsertTempKeyCount_Get")
#End If
End Property

Property Let User_ID(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:User_ID_Let")
#End If
  
  ms_User_ID = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:User_ID_Let")
#End If
End Property

Property Get User_ID() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:User_ID_Get")
#End If
  
  User_ID = ms_User_ID

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:User_ID_Get")
#End If
End Property

Property Let SPRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SPRequest_Let")
#End If
  
  ms_SPRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SPRequest_Let")
#End If
End Property

Property Get SPRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SPRequest_Get")
#End If
  
  SPRequest = ms_SPRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SPRequest_Get")
#End If
End Property

Property Let SalesRepRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SalesRepRequest_Let")
#End If
  
  ms_SalesRepRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SalesRepRequest_Let")
#End If
End Property

Property Get SalesRepRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SalesRepRequest_Get")
#End If
  
  SalesRepRequest = ms_SalesRepRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SalesRepRequest_Get")
#End If
End Property

Property Let CompanyRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CompanyRequest_Let")
#End If
  
  ms_CompanyRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CompanyRequest_Let")
#End If
End Property

Property Get CompanyRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CompanyRequest_Get")
#End If
  
  CompanyRequest = ms_CompanyRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CompanyRequest_Get")
#End If
End Property

Property Let ItemsRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ItemsRequest_Let")
#End If
  
  ms_ItemsRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ItemsRequest_Let")
#End If
End Property

Property Get ItemsRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ItemsRequest_Get")
#End If
  
  ItemsRequest = ms_ItemsRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ItemsRequest_Get")
#End If
End Property

Property Let ActionRequest(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ActionRequest_Let")
#End If
  
  ms_ActionRequest = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ActionRequest_Let")
#End If
End Property

Property Get ActionRequest() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ActionRequest_Get")
#End If
  
  ActionRequest = ms_ActionRequest

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ActionRequest_Get")
#End If
End Property

Property Let Language_Code(as_Value As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:Language_Code_Let")
#End If
  
  ms_Language_Code = as_Value

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:Language_Code_Let")
#End If
End Property

Property Get Language_Code() As String
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:Language_Code_Get")
#End If
  
  Language_Code = ms_Language_Code

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:Language_Code_Get")
#End If
End Property

'set array of key compatible to armgrid
Property Let MultiKey(av_Value As Variant)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:MultiKey_Let")
#End If
  
  If IsArray(av_Value) Then
    mv_MultiKey = av_Value
  Else
    mv_MultiKey = Array(av_Value)
  End If

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:MultiKey_Let")
#End If
End Property

Property Get MultiKey() As Variant
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:MultiKey_Get")
#End If
  
  MultiKey = mv_MultiKey

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:MultiKey_Get")
#End If
End Property

Public Sub SetConstantRequest(as_Request As String, as_LabelField As String, as_TextField As String)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SetConstantRequest")
#End If
  
  ms_LabelRequest = as_Request
  ms_LabelField = as_LabelField
  ms_TextField = as_TextField

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SetConstantRequest")
#End If
End Sub

Public Function IsConnected() As Boolean
Dim lb_Result As Boolean

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:IsConnected")
#End If
  
  IsConnected = False
  If Not mo_Db Is Nothing Then
    IsConnected = mo_Db.IsConnected
  End If

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:IsConnected")
#End If
End Function

Private Function CreateTempTable() As Boolean

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CreateTempTable")
#End If
  
  CreateTempTable = ExecuteRequest(ms_CreateTempTableRequest)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CreateTempTable")
#End If
End Function

Private Function DropTempTable() As Boolean

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:DropTempTable")
#End If
  
  DropTempTable = ExecuteRequest(ms_DropTempTableRequest)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:DropTempTable")
#End If
End Function

Private Function InsertTempKeys(ByRef al_Index As Long) As Boolean
Dim ll_KeyIndex As Long, ll_ColIndex As Long
Dim ls_TempRequest As String
Dim lv_Key As Variant

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:InsertTempKeys")
#End If
  
  ls_TempRequest = ms_InsertTempKeyRequest
  ll_KeyIndex = 0
  Do While (ll_KeyIndex < ml_InsertTempKeyCount) And (al_Index <= UBound(mv_MultiKey))
  
    lv_Key = mv_MultiKey(al_Index)
    
    If IsArray(lv_Key) Then
      For ll_ColIndex = 0 To UBound(lv_Key)
        ls_TempRequest = Replace(ls_TempRequest, "$" & ll_KeyIndex & "$", Replace(lv_Key(ll_ColIndex), "'", "''"))
        ll_KeyIndex = ll_KeyIndex + 1
      Next
    Else
      ls_TempRequest = Replace(ls_TempRequest, "$" & ll_KeyIndex & "$", Replace(lv_Key, "'", "''"))
      ll_KeyIndex = ll_KeyIndex + 1
    End If
    al_Index = al_Index + 1
  Loop
  
  Do While ll_KeyIndex < ml_InsertTempKeyCount
    ls_TempRequest = Replace(ls_TempRequest, "$" & ll_KeyIndex & "$", "")
    ll_KeyIndex = ll_KeyIndex + 1
  Loop
  InsertTempKeys = ExecuteRequest(ls_TempRequest)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:InsertTempKeys")
#End If
  Exit Function
ErrorHandler:
  InsertTempKeys = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:InsertTempKeys")
#End If
End Function

Private Function FillTempKeyTable() As Boolean
Dim lb_Result As Boolean
Dim ll_RowIndex As Long

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:FillTempKeyTable")
#End If
  
  lb_Result = False
  Call DropTempTable
  If CreateTempTable Then
    If IsArray(mv_MultiKey) Then
      ll_RowIndex = 0
      Do While ll_RowIndex <= UBound(mv_MultiKey)
        lb_Result = InsertTempKeys(ll_RowIndex)
        If Not lb_Result Then Exit Do
      Loop
    End If
  End If
  FillTempKeyTable = lb_Result

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:FillTempKeyTable")
#End If
  Exit Function
ErrorHandler:
  FillTempKeyTable = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:FillTempKeyTable")
#End If
End Function

Private Function TranslateTemplate(as_Cells As String) As Boolean
Dim lo_WorkSheetTemp As Object
Dim la_Labels() As String, ls_Label As String
Dim ll_Index As Long, ll_Row As Long, ll_Col As Long
Dim ll_Cursor As Long

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:TranslateTemplate")
#End If

  Call mo_TemplateWorkbook.Activate
  Set lo_WorkSheetTemp = mo_TemplateWorkbook.Worksheets(1)
  Call lo_WorkSheetTemp.Activate
  
  ll_Cursor = OpenCursor(ms_LabelRequest)
  If ll_Cursor > 0 Then
    la_Labels = Split(as_Cells)
    For ll_Index = 0 To UBound(la_Labels)
      ll_Col = Asc(Left(la_Labels(ll_Index), 1)) - Asc("A") + 1
      ll_Row = CLng(right(la_Labels(ll_Index), Len(la_Labels(ll_Index)) - 1))
      ls_Label = CStr(GetCell(lo_WorkSheetTemp, ll_Row, ll_Col))
      If mo_Db.Find(ll_Cursor, ms_LabelField, ls_Label, , 1) >= 0 Then
        ls_Label = mo_Db.GetFields(ll_Cursor, ms_TextField)
      End If
      Call SetCell(lo_WorkSheetTemp, ll_Row, ll_Col, ls_Label)
    Next
    Call CloseCursor(ll_Cursor)
    TranslateTemplate = True
  Else
    TranslateTemplate = False
  End If
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:TranslateTemplate")
#End If
  Exit Function
ErrorHandler:
  TranslateTemplate = False
  Call CloseCursor(ll_Cursor)
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:TranslateTemplate")
#End If
End Function

Private Function CopyTemplate() As Boolean
Dim lo_WorkSheetSrc As Object

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CopyTemplate")
#End If

  Call mo_TemplateWorkbook.Activate
  Set lo_WorkSheetSrc = mo_TemplateWorkbook.Worksheets(1)
  Call lo_WorkSheetSrc.Activate
  Call lo_WorkSheetSrc.cells.Copy
  CopyTemplate = True
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CopyTemplate")
#End If
  Exit Function
ErrorHandler:
  CopyTemplate = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:CopyTemplate")
#End If
End Function


Private Function FillTemplateListe() As Boolean
Dim lo_WorkSheet As Object
Dim ld_Date As Date
Dim ll_PrjCompCursor As Long
Dim ll_Count As Long, ll_Index As Long

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:FillTemplateListe")
#End If
  
  Set lo_WorkSheet = mo_Workbook.Worksheets(1)
  'ls_SP_CapKey = av_Key
  'If mo_Db.Find(ml_SPCursor, "SP_CAPKEY", ls_SP_CapKey) >= 0 Then
  'fill all sales project information
  Call SetCell(lo_WorkSheet, ml_RowCounter, 1, mo_Db.GetFields(ml_SPCursor, "SP_DESC"))
  'put project name in bold
  Call SetCellAttr(lo_WorkSheet, ml_RowCounter, 1, True)
  Call SetCell(lo_WorkSheet, ml_RowCounter, 2, mo_Db.GetFields(ml_SPCursor, "SP_ADDR1"))
  Call SetCell(lo_WorkSheet, ml_RowCounter, 3, mo_Db.GetFields(ml_SPCursor, "SP_ADDR2"))
  Call SetCell(lo_WorkSheet, ml_RowCounter, 4, mo_Db.GetFields(ml_SPCursor, "SP_ZIP"))
  Call SetCell(lo_WorkSheet, ml_RowCounter, 5, mo_Db.GetFields(ml_SPCursor, "SP_TOWN"))
  Call SetCell(lo_WorkSheet, ml_RowCounter, 6, mo_Db.GetFields(ml_SPCursor, "SS_DESC"))
  Call SetCell(lo_WorkSheet, ml_RowCounter, 7, mo_Db.GetFields(ml_SPCursor, "SP_SIZE"))
  ld_Date = mo_Db.GetFields(ml_SPCursor, "SP_STARTDATE")
  If ld_Date <> 0 Then Call SetCell(lo_WorkSheet, ml_RowCounter, 8, ld_Date)
  ld_Date = mo_Db.GetFields(ml_SPCursor, "SP_CEILINGSTARTINGDATE")
  If ld_Date <> 0 Then Call SetCell(lo_WorkSheet, ml_RowCounter, 9, ld_Date)
  
  'move to next row
  ml_RowCounter = ml_RowCounter + 1
  ll_PrjCompCursor = OpenCursor(ms_CompanyRequest, ml_SPCursor)
  If ll_PrjCompCursor > 0 Then
    'll_PrjCompCursor = mo_Db.Filter(ll_PrjCompCursor, "CCT_CODE", "<>", 11, , True)
    ll_PrjCompCursor = mo_Db.Sort(ll_PrjCompCursor, "CCU_DESC", , True)
    If ll_PrjCompCursor > 0 Then
      ll_Count = mo_Db.RowCount(ll_PrjCompCursor)
      For ll_Index = 0 To ll_Count - 1
        Call SetCell(lo_WorkSheet, ml_RowCounter, 1, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_DESC"))
        Call SetCell(lo_WorkSheet, ml_RowCounter, 2, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_ADDR1"))
        Call SetCell(lo_WorkSheet, ml_RowCounter, 3, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_ADDR2"))
        Call SetCell(lo_WorkSheet, ml_RowCounter, 4, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_ZIP"))
        Call SetCell(lo_WorkSheet, ml_RowCounter, 5, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_TOWN"))
        Call SetCell(lo_WorkSheet, ml_RowCounter, 6, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CNT_FIRSTNAME") & _
                                               " " & mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CNT_LASTNAME"))
        Call SetCell(lo_WorkSheet, ml_RowCounter, 7, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CNT_TELOFFICE"))
        ml_RowCounter = ml_RowCounter + 1
      Next
    End If
    Call CloseCursor(ll_PrjCompCursor)
  End If
  'add translated "memo/comment from customer" label from internal variable
  Call SetCell(lo_WorkSheet, ml_RowCounter, 1, ms_CommentLabel)
  'put memo/comment from customer in bold
  Call SetCellAttr(lo_WorkSheet, ml_RowCounter, 1, True)
  'add one blank line
  ml_RowCounter = ml_RowCounter + 2
  
  FillTemplateListe = True
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:FillTemplateListe")
#End If
  Exit Function
ErrorHandler:
  Call CloseCursor(ll_PrjCompCursor)
  FillTemplateListe = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:FillTemplateListe")
#End If
End Function

Private Function FillTemplateBlatt(al_Index As Long) As Boolean
Dim lo_WorkSheet As Object
Dim ld_Date As Date
Dim ll_Count As Long, ll_Index As Long
Dim ll_PrjCompCursor As Long
Dim ll_PrjItemsCursor As Long
Dim ll_ActionCursor As Long
Dim ll_SalesRepCursor As Long


On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:FillTemplateBlatt")
#End If
  
  Set lo_WorkSheet = mo_Workbook.Worksheets(al_Index + 1)
  'fill alll sales project information
  Call SetSheetName(lo_WorkSheet, mo_Db.GetFields(ml_SPCursor, "SP_DESC"))
  Call SetCell(lo_WorkSheet, 4, 1, mo_Db.GetFields(ml_SPCursor, "SP_DESC"))
  Call SetCell(lo_WorkSheet, 7, 2, mo_Db.GetFields(ml_SPCursor, "SP_DESC"))
  Call SetCell(lo_WorkSheet, 8, 2, mo_Db.GetFields(ml_SPCursor, "SP_TOWN"))
  Call SetCell(lo_WorkSheet, 9, 2, mo_Db.GetFields(ml_SPCursor, "SP_ADDR1"))
  Call SetCell(lo_WorkSheet, 10, 2, mo_Db.GetFields(ml_SPCursor, "SP_ADDR2"))
  Call SetCell(lo_WorkSheet, 11, 2, mo_Db.GetFields(ml_SPCursor, "SP_ZIP"))

  Call SetCell(lo_WorkSheet, 13, 2, mo_Db.GetFields(ml_SPCursor, "PT_DESC"))
  Call SetCell(lo_WorkSheet, 14, 2, mo_Db.GetFields(ml_SPCursor, "SS_DESC"))
  Call SetCell(lo_WorkSheet, 15, 2, mo_Db.GetFields(ml_SPCursor, "SP_SIZE"))
  Call SetCell(lo_WorkSheet, 17, 2, mo_Db.GetFields(ml_SPCursor, "NR_DESC"))
  Call SetCell(lo_WorkSheet, 18, 2, mo_Db.GetFields(ml_SPCursor, "PP_DESC"))
  Call SetCell(lo_WorkSheet, 19, 2, mo_Db.GetFields(ml_SPCursor, "PD_DESC"))
  
  Call SetCell(lo_WorkSheet, 26, 1, mo_Db.GetFields(ml_SPCursor, "SP_COMMENT"))
  
  ld_Date = mo_Db.GetFields(ml_SPCursor, "SP_STARTDATE")
  If ld_Date <> 0 Then Call SetCell(lo_WorkSheet, 20, 2, ld_Date)
  ld_Date = mo_Db.GetFields(ml_SPCursor, "SP_CEILINGSTARTINGDATE")
  If ld_Date <> 0 Then Call SetCell(lo_WorkSheet, 21, 2, ld_Date)

  ll_SalesRepCursor = OpenCursor(ms_SalesRepRequest, ml_SPCursor)
  If ll_SalesRepCursor > 0 Then
    If mo_Db.RowCount(ll_SalesRepCursor) > 0 Then
      Call SetCell(lo_WorkSheet, 2, 4, mo_Db.GetFieldsAt(ll_SalesRepCursor, 0, "SR_NAME"))
      Call SetCell(lo_WorkSheet, 3, 4, mo_Db.GetFieldsAt(ll_SalesRepCursor, 0, "PHONE"))
      Call SetCell(lo_WorkSheet, 4, 4, mo_Db.GetFieldsAt(ll_SalesRepCursor, 0, "FAX"))
    End If
    Call CloseCursor(ll_SalesRepCursor)
  End If
  
  If ItemsRequest <> "" Then
    ll_PrjItemsCursor = OpenCursor(ms_ItemsRequest, ml_SPCursor)
    If ll_PrjItemsCursor > 0 Then
      ll_Count = mo_Db.RowCount(ll_PrjItemsCursor)
      If ll_Count > 0 Then
        For ll_Index = 1 To ll_Count - 1
          lo_WorkSheet.Rows(32).Insert
          'copy format from first table row to inserted row, because it would take format from title
          lo_WorkSheet.Rows(32 + ll_Index).Copy
          Call lo_WorkSheet.Rows(32).PasteSpecial(-4122, -4142, False, False)
        Next
        For ll_Index = 0 To ll_Count - 1
          Call SetCell(lo_WorkSheet, ll_Index + 32, 1, mo_Db.GetFieldsAt(ll_PrjItemsCursor, ll_Index, "S_Code"))
          Call SetCell(lo_WorkSheet, ll_Index + 32, 2, mo_Db.GetFieldsAt(ll_PrjItemsCursor, ll_Index, "S_Desc"))
          Call SetCell(lo_WorkSheet, ll_Index + 32, 3, mo_Db.GetFieldsAt(ll_PrjItemsCursor, ll_Index, "MA_desc"))
          Call SetCell(lo_WorkSheet, ll_Index + 32, 4, mo_Db.GetFieldsAt(ll_PrjItemsCursor, ll_Index, "SS_qty"))
          Call SetCell(lo_WorkSheet, ll_Index + 32, 5, mo_Db.GetFieldsAt(ll_PrjItemsCursor, ll_Index, "UM_Code"))
        Next
      End If
      Call CloseCursor(ll_PrjItemsCursor)
    End If
  End If
  
  ll_ActionCursor = OpenCursor(ms_ActionRequest, ml_SPCursor)
  If ll_ActionCursor > 0 Then
    ll_ActionCursor = mo_Db.Sort(ll_ActionCursor, "ACT_DUEDATE", Array(True), True)
    ll_Count = mo_Db.RowCount(ll_ActionCursor)
    If ll_Count > 0 Then
      For ll_Index = 1 To ll_Count - 1
        lo_WorkSheet.Rows(29).Insert
        'copy format from first table row to inserted row, because it would take format from title
        lo_WorkSheet.Rows(29 + ll_Index).Copy
        Call lo_WorkSheet.Rows(29).PasteSpecial(-4122, -4142, False, False)
      Next
      For ll_Index = 0 To ll_Count - 1
        Call SetCell(lo_WorkSheet, ll_Index + 29, 1, mo_Db.GetFieldsAt(ll_ActionCursor, ll_Index, "ACT_RAISEDBY"))
        Call SetCell(lo_WorkSheet, ll_Index + 29, 2, mo_Db.GetFieldsAt(ll_ActionCursor, ll_Index, "CNT_FIRSTNAME") & _
                                               " " & mo_Db.GetFieldsAt(ll_ActionCursor, ll_Index, "CNT_LASTNAME"))
        Call SetCell(lo_WorkSheet, ll_Index + 29, 3, mo_Db.GetFieldsAt(ll_ActionCursor, ll_Index, "ACT_DUEDATE"))
        Call SetCell(lo_WorkSheet, ll_Index + 29, 4, mo_Db.GetFieldsAt(ll_ActionCursor, ll_Index, "ACT_COMMENT"))
      Next
    End If
    Call CloseCursor(ll_ActionCursor)
  End If
  
  ll_PrjCompCursor = OpenCursor(ms_CompanyRequest, ml_SPCursor)
  If ll_PrjCompCursor > 0 Then
    'll_PrjCompCursor = mo_Db.Filter(ll_PrjCompCursor, "CCT_CODE", "<>", 11, , True)
    ll_PrjCompCursor = mo_Db.Sort(ll_PrjCompCursor, "CCU_DESC", , True)
    ll_Count = mo_Db.RowCount(ll_PrjCompCursor)
    If ll_Count > 0 Then
      For ll_Index = 1 To ll_Count - 1
        lo_WorkSheet.Rows(24).Insert
        'copy format from first table row to inserted row, because it would take format from title
        lo_WorkSheet.Rows(24 + ll_Index).Copy
        Call lo_WorkSheet.Rows(24).PasteSpecial(-4122, -4142, False, False)
      Next
      For ll_Index = 0 To ll_Count - 1
        Call SetCell(lo_WorkSheet, ll_Index + 24, 1, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCT_DESC"))
        Call SetCell(lo_WorkSheet, ll_Index + 24, 2, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_DESC"))
        Call SetCell(lo_WorkSheet, ll_Index + 24, 3, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CCU_TOWN"))
        Call SetCell(lo_WorkSheet, ll_Index + 24, 4, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CNT_FIRSTNAME") & _
                                               " " & mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CNT_LASTNAME"))
        Call SetCell(lo_WorkSheet, ll_Index + 24, 5, mo_Db.GetFieldsAt(ll_PrjCompCursor, ll_Index, "CNT_TELOFFICE"))
      Next
    End If
    Call CloseCursor(ll_PrjCompCursor)
  End If
  
  FillTemplateBlatt = True
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:FillTemplateBlatt")
#End If
  Exit Function
ErrorHandler:
  Call CloseCursor(ll_SalesRepCursor)
  Call CloseCursor(ll_ActionCursor)
  Call CloseCursor(ll_PrjCompCursor)
  FillTemplateBlatt = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:FillTemplateBlatt")
#End If
End Function

Private Function PasteTemplate(Optional al_Index As Long = 0) As Boolean
Dim lo_WorkSheet As Object

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:PasteTemplate")
#End If
  
  Call mo_Workbook.Activate
  If al_Index >= mo_Workbook.Worksheets.Count Then
    Call mo_Workbook.Worksheets.Add(, mo_Workbook.Worksheets(al_Index))
  End If
  Set lo_WorkSheet = mo_Workbook.Worksheets(al_Index + 1)
  Call lo_WorkSheet.Activate
  Call lo_WorkSheet.cells.Select
  Call lo_WorkSheet.Paste
  Call lo_WorkSheet.cells(1, 1).Select
  PasteTemplate = True
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:PasteTemplate")
#End If
  Exit Function
ErrorHandler:
  PasteTemplate = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:PasteTemplate")
#End If
End Function

Public Function ExportListe(as_TemplateFile As String) As Boolean
Dim lb_Result As Boolean
Dim lo_WorkSheetTemp As Object

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ExportListe")
#End If
  
  lb_Result = False
  Call SetMousePointer(False)
  ml_RowCounter = 2
  
  If FillTempKeyTable Then
    ml_SPCursor = OpenCursor(ms_SPRequest)
  End If
  'temporary table is not needed we can drop it here
  Call DropTempTable
  
  If ml_SPCursor > 0 Then
    Set mo_TemplateWorkbook = OpenExcelDocument(as_TemplateFile)
    If Not (mo_TemplateWorkbook Is Nothing) Then
      Set mo_Workbook = NewExcelDocument
      If Not (mo_Workbook Is Nothing) Then
        mo_ExcelApp.ScreenUpdating = False
        Set mo_Sheet = mo_ExcelApp.ActiveSheet
        If Not (mo_Sheet Is Nothing) Then
          If TranslateTemplate("A1 B1 C1 D1 E1 F1 G1 H1 I1 A2") Then
            'save "memo/comment from customer" label from cell A2 into variable and clear cell
            Call mo_TemplateWorkbook.Activate
            Set lo_WorkSheetTemp = mo_TemplateWorkbook.Worksheets(1)
            Call lo_WorkSheetTemp.Activate
            ms_CommentLabel = GetCell(lo_WorkSheetTemp, 2, 1)
            Call SetCell(lo_WorkSheetTemp, 2, 1, Empty)
            If CopyTemplate Then
              If PasteTemplate Then
                lb_Result = True
                Do While Not mo_Db.EOF(ml_SPCursor)
                  If Not FillTemplateListe Then
                    lb_Result = False
                    Exit Do
                  End If
                  Call mo_Db.Next(ml_SPCursor)
                Loop
              End If
            End If
          End If
        End If
      End If
    End If
    Call CloseCursor(ml_SPCursor)
  End If
  
  Call SetMousePointer(True)
  mo_ExcelApp.CutCopyMode = False
  Call mo_TemplateWorkbook.Close(False)
  Set mo_TemplateWorkbook = Nothing
  mo_ExcelApp.ScreenUpdating = True
  ExportListe = lb_Result

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ExportListe")
#End If
  Exit Function
ErrorHandler:
  Call SetMousePointer(True)
  Call CloseCursor(ml_SPCursor)
  If Not mo_ExcelApp Is Nothing Then
    mo_ExcelApp.CutCopyMode = False
  End If
  If Not mo_TemplateWorkbook Is Nothing Then
    Call mo_TemplateWorkbook.Close(False)
    Set mo_TemplateWorkbook = Nothing
  End If
  If Not mo_ExcelApp Is Nothing Then
    mo_ExcelApp.ScreenUpdating = True
  End If
  ExportListe = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:ExportListe")
#End If
End Function

Public Function ExportBlatt(ByVal as_TemplateFile As String, Optional ByVal as_FileName As String = "") As Boolean
Dim lb_Result As Boolean
Dim ll_Index As Long

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ExportBlatt")
#End If
  
  lb_Result = False
  Call SetMousePointer(False)
  
  If FillTempKeyTable Then
    ml_SPCursor = OpenCursor(ms_SPRequest)
  End If
  'temporary table is not needed we can drop it here
  Call DropTempTable
  
  If ml_SPCursor > 0 Then
    Set mo_TemplateWorkbook = OpenExcelDocument(as_TemplateFile)
    If Not (mo_TemplateWorkbook Is Nothing) Then
      Set mo_Workbook = NewExcelDocument
      If Not (mo_Workbook Is Nothing) Then
        mo_ExcelApp.ScreenUpdating = False
        Set mo_Sheet = mo_ExcelApp.ActiveSheet
        If Not (mo_Sheet Is Nothing) Then
          If TranslateTemplate("D1 C2 A7 A8 A9 A10 A11 A13 A14 A15 A17 A18 A19 A20 A21 " + _
                                "A23 B23 C23 D23 E23 A25 A27 A28 B28 C28 D28 A30 A31 B31 C31 D31 E31") Then
            lb_Result = True
            ll_Index = 0
            Do While Not mo_Db.EOF(ml_SPCursor)
              If CopyTemplate Then
                If PasteTemplate(ll_Index) Then
                  If Not FillTemplateBlatt(ll_Index) Then
                    lb_Result = False
                    Exit Do
                  End If
                Else
                  lb_Result = False
                  Exit Do
                End If
              Else
                lb_Result = False
                Exit Do
              End If
              Call mo_Db.Next(ml_SPCursor)
              ll_Index = ll_Index + 1
            Loop
          End If
        End If
      End If
    End If
    Call CloseCursor(ml_SPCursor)
  End If
  
  Call SetMousePointer(True)
  mo_ExcelApp.CutCopyMode = False
  
    If as_FileName <> "" Then
        Call mo_Workbook.Close(True, as_FileName)
    End If
    Call mo_TemplateWorkbook.Close(False)
  Set mo_TemplateWorkbook = Nothing
  mo_ExcelApp.ScreenUpdating = True
  ExportBlatt = lb_Result

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ExportBlatt")
#End If
  Exit Function
ErrorHandler:
  Call SetMousePointer(True)
  Call CloseCursor(ml_SPCursor)
  If Not mo_ExcelApp Is Nothing Then
    mo_ExcelApp.CutCopyMode = False
  End If
  If Not mo_TemplateWorkbook Is Nothing Then
    Call mo_TemplateWorkbook.Close(False)
    Set mo_TemplateWorkbook = Nothing
  End If
  If Not mo_ExcelApp Is Nothing Then
    mo_ExcelApp.ScreenUpdating = True
  End If
  ExportBlatt = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:ExportBlatt")
#End If
End Function

Private Function ExportClose() As Boolean

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ExportClose")
#End If
  
  ExportClose = False
  If Not (mo_ExcelApp Is Nothing) Then
    mo_ExcelApp.ScreenUpdating = True
    Set mo_Sheet = Nothing
    Set mo_ExcelApp = Nothing
    ExportClose = True
  End If

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ExportClose")
#End If
  Exit Function
ErrorHandler:
  ExportClose = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:ExportClose")
#End If
End Function

Private Function OpenExcelDocument(as_Name As String) As Object
Dim lo_WorkBook As Object
Dim lo_TemplateBook As Object
Dim lo_WorkSheet As Object
Dim lb_Found As Boolean

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:OpenExcelDocument")
#End If
    
    Set OpenExcelDocument = Nothing
    
    On Error GoTo Err_NotLoaded
    
    Set mo_ExcelApp = GetObject(, "Excel.Application")
    
    If mo_ExcelApp Is Nothing Then
        Set mo_ExcelApp = CreateObject("Excel.Application")
    End If
    
    If mo_ExcelApp Is Nothing Then GoTo ErrorHandler
    
    On Error GoTo ErrorHandler
    
    lb_Found = False
    For Each lo_WorkBook In mo_ExcelApp.Workbooks
      If StrComp(lo_WorkBook.FullName, as_Name, vbTextCompare) = 0 Then
        Set lo_TemplateBook = lo_WorkBook
        lb_Found = True
      End If
    Next
    If Not lb_Found Then
      Set lo_TemplateBook = mo_ExcelApp.Workbooks.Open(as_Name)
    End If
    
    Set OpenExcelDocument = lo_TemplateBook
    
    Set lo_WorkSheet = lo_TemplateBook.Worksheets(1)
    mo_ExcelApp.Application.Visible = True
    lo_WorkSheet.Application.Visible = True

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:OpenExcelDocument")
#End If
    Exit Function
    
Err_NotLoaded:
    If Err.Number = 429 Then
        Resume Next
    End If
    
ErrorHandler:
    Set mo_ExcelApp = Nothing
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:OpenExcelDocument")
#End If
End Function

Private Function NewExcelDocument() As Object
Dim lo_WorkBook As Object
Dim lo_WorkSheet As Object

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:NewExcelDocument")
#End If
    
    Set NewExcelDocument = Nothing
    
    On Error GoTo Err_NotLoaded
    
    Set mo_ExcelApp = GetObject(, "Excel.Application")
    
    If mo_ExcelApp Is Nothing Then
        Set mo_ExcelApp = CreateObject("Excel.Application")
    End If
    
    If mo_ExcelApp Is Nothing Then GoTo ErrorHandler
    
    On Error GoTo ErrorHandler
    
    Set lo_WorkBook = mo_ExcelApp.Workbooks.Add
    Set lo_WorkSheet = lo_WorkBook.Worksheets(1)
    mo_ExcelApp.Application.Visible = True
    lo_WorkSheet.Application.Visible = True

    Set NewExcelDocument = lo_WorkBook

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:NewExcelDocument")
#End If
    Exit Function
    
Err_NotLoaded:
    If Err.Number = 429 Then
        Resume Next
    End If
    
ErrorHandler:
    Set mo_ExcelApp = Nothing
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:NewExcelDocument")
#End If
End Function

Private Function SetCell(ao_Sheet As Object, al_Row As Long, al_Col As Long, av_Value As Variant)

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SetCell")
#End If
  If VarType(av_Value) = vbString Then
    ao_Sheet.cells(al_Row, al_Col) = ConvertCodePageFromAnsi("'" & Trim(CStr(av_Value)), ml_CodePage)
  Else
    ao_Sheet.cells(al_Row, al_Col) = av_Value
  End If
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SetCell")
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:SetCell")
#End If
End Function



Private Function SetSheetName(ao_Sheet As Object, av_Value As Variant)

On Error GoTo ErrorHandler

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SetCell")
#End If
  
  Dim ll_Idx As Long
  Dim lv_Value As Variant
  
  av_Value = Replace(av_Value, "\", "")
  av_Value = Replace(av_Value, "/", "")
  av_Value = Replace(av_Value, "?", "")
  av_Value = Replace(av_Value, "*", "")
  av_Value = Replace(av_Value, "[", "")
  av_Value = Replace(av_Value, "]", "")
  av_Value = Left(av_Value, 31)
  
  lv_Value = av_Value
  
  ll_Idx = 2
  If VarType(lv_Value) = vbString Then
    ao_Sheet.Name = ConvertCodePageFromAnsi(Trim(CStr(lv_Value)), ml_CodePage)
  Else
    ao_Sheet.Name = lv_Value
  End If

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SetCell")
#End If
  Exit Function
ErrorHandler:

 If Err.Number = 1004 Then
    lv_Value = Left(lv_Value, 31 - Len(CStr(ll_Idx)) - 3)
    lv_Value = lv_Value & " (" & ll_Idx & ")"
    ll_Idx = ll_Idx + 1
    Resume
 End If

#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:SetCell")
#End If
End Function



Private Function SetCellAttr(ao_Sheet As Object, al_Row As Long, al_Col As Long, ab_Bold As Boolean)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SetCellAttr")
#End If
  
  ao_Sheet.cells(al_Row, al_Col).Font.Bold = ab_Bold
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SetCellAttr")
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:SetCellAttr")
#End If
End Function

Private Function GetCell(ao_Sheet As Object, al_Row As Long, al_Col As Long) As Variant

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:GetCell")
#End If
  
  GetCell = ConvertCodePageFromUnicode(ao_Sheet.cells(al_Row, al_Col), ml_CodePage)
  
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:GetCell")
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:GetCell")
#End If
End Function
'replace all field placeholders by its values acording checklist
Private Function ReplacePlaceholders(ByVal as_Request As String) As String
 
On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ReplacePlaceholders")
#End If
  
  'replace placeholder for current time
  as_Request = Replace(as_Request, "$User_ID$", Replace(ms_User_ID, "'", "''"), , , vbTextCompare)
  as_Request = Replace(as_Request, "$LangCode$", Replace(ms_Language_Code, "'", "''"), , , vbTextCompare)
  
  ReplacePlaceholders = as_Request

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ReplacePlaceholders")
#End If
  Exit Function
ErrorHandler:
  ReplacePlaceholders = as_Request
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:ReplacePlaceholders", "as_Request=" & as_Request)
#End If
End Function

'open cursor with request as_Request and return cursor
Private Function OpenCursor(ByVal as_Request As String, Optional al_Cursor As Long = 0) As Long
Dim ll_Index As Long
Dim ls_value As String
  
On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:OpenCursor")
#End If
  
  Call SetMousePointer(False)
  OpenCursor = 0
  If Not IsConnected Then
    If Not OpenConnection(ms_Server, ms_Db, ms_User, ms_Pwd, ms_App) Then
#If CompDebug Then
        Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmExcelLead:OpenCursor", "ms_Server=" & ms_Server, _
          "ms_Db=" & ms_Db, "ms_User=" & ms_User, "ms_Pwd=" & ms_Pwd)
#End If
    End If
  End If
  
  as_Request = ReplacePlaceholders(as_Request)
  If al_Cursor Then
    For ll_Index = 0 To mo_Db.FieldCount(al_Cursor) - 1
      ls_value = mo_Db.GetFields(al_Cursor, ll_Index)
      as_Request = Replace(as_Request, "$" & ll_Index & "$", ls_value)
      as_Request = Replace(as_Request, "$" & mo_Db.GetFieldName(al_Cursor, ll_Index) & "$", ls_value, , , vbTextCompare)
    Next
  End If
  
  OpenCursor = mo_Db.OpenSQL(as_Request)
  If OpenCursor = 0 Then
#If CompDebug Then
      Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmExcelLead:OpenCursor", "as_Request=" & as_Request)
#End If
  End If
  Call SetMousePointer(True)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:OpenCursor")
#End If
  Exit Function
ErrorHandler:
  Call SetMousePointer(True)
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:OpenCursor", "as_Request=" & as_Request)
#End If
End Function

Private Function CloseCursor(ByRef al_Cursor As Long) As Boolean

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CloseCursor")
#End If
  
  If al_Cursor Then
    Call mo_Db.Close(al_Cursor)
    al_Cursor = 0
  End If

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CloseCursor")
#End If
End Function

'execute SQL request on server
Private Function ExecuteRequest(ByVal as_Request As String) As Boolean
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:ExecuteRequest")
#End If
  
  Call SetMousePointer(False)
On Error GoTo ErrorHandler

  ExecuteRequest = False
  If Not IsConnected Then
    If Not OpenConnection(ms_Server, ms_Db, ms_User, ms_Pwd, ms_App) Then
#If CompDebug Then
        Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmExcelLead:ExecuteRequest", "ms_Server=" & ms_Server, _
          "ms_Db=" & ms_Db, "ms_User=" & ms_User, "ms_Pwd=" & ms_Pwd)
#End If
    End If
  End If
  as_Request = ReplacePlaceholders(as_Request)
  ExecuteRequest = mo_Db.ExecuteSQL(as_Request)
  If Not ExecuteRequest Then
#If CompDebug Then
    Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmExcelLead:ExecuteRequest", "as_Request=" & as_Request)
#End If
  End If
  Call SetMousePointer(True)

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:ExecuteRequest")
#End If
  Exit Function
  
ErrorHandler:
  ExecuteRequest = False
  Call SetMousePointer(True)
End Function

'open conection and create own instance of ArmDB if it was not passed through property
Private Function OpenConnection(as_Server As String, as_Db As String, as_User As String, _
    as_Pwd As String, as_App As String) As Boolean
Dim lb_Result As Boolean

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:OpenConnection")
#End If

  lb_Result = False
  If Not IsConnected Then
    mb_InternalConnection = True
    If mo_Db Is Nothing Then
      Set mo_Db = CreateObject("ARMSYSCOM.ArmDb")
    End If

    If (as_Server <> "") And (as_Db <> "") And (as_User <> "") Then
        If mo_Db.Connect(as_Server, as_Db, as_User, as_Pwd, as_App) Then
          lb_Result = mo_Db.IsConnected
        Else
#If CompDebug Then
          Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmExcelLead:OpenConnectionn")
#End If
        End If
    End If
  End If
  OpenConnection = lb_Result

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:OpenConnection")
#End If
  Exit Function
ErrorHandler:
  OpenConnection = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:OpenConnection", "as_Server=" & as_Server, _
  "as_Db=" & as_Db, "as_User=" & as_User)
#End If
End Function

'close connection if connection was created with OpenConnection method and
Private Sub CloseConnection()

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:CloseConnection")
#End If
 
  If IsConnected Then
    Call mo_Db.Disconnect
    mb_InternalConnection = False
  End If

#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:CloseConnection")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:CloseConnection")
#End If
End Sub

'**************************************************************************************************************
'turn of on mouse pointer sand hour glass, use counter
Private Static Sub SetMousePointer(lb_Enable As Boolean)
Dim li_Count As Integer
Dim li_OldPointer As Integer

On Error GoTo ErrorHandler
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(True, "ArmExcelLead:SetMousePointer")
#End If
  
  If lb_Enable Then
    If li_Count > 0 Then li_Count = li_Count - 1
    If li_Count <= 0 Then
      'set back old state
      Screen.MousePointer = li_OldPointer
    End If
  Else
    li_Count = li_Count + 1
    'remember state of pointer before first change
    If li_Count = 1 Then li_OldPointer = Screen.MousePointer
    Screen.MousePointer = vbHourglass
  End If
#If CompDebugEX Then
  Call mo_Trace.WriteTraceProc(False, "ArmExcelLead:SetMousePointer")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmExcelLead:SetMousePointer")
#End If
End Sub

